;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; It expects screen 1 or screen 2 "hybrid" mode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

softscroll:

            xor    a                      ; Tile colors
            out    (99h),a
            ld     a,64+20h
            out    (99h),a
            ld      bc,0x98
            ld      a,0xf1

1:          out    (0x98),a
            djnz    1b
1:          out    (0x98),a
            djnz    1b

            xor    a                      ; Tile colors
            out    (99h),a
            ld     a,64+00h

            xor    a                      ; Tile colors
            ld      d,8
1:          out    (0x98),a
            djnz    1b
            dec     d
            jr      nz,1b
            
                                         ; D = text line counter
            ld      de,0                 ; E = pixel counter

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; outer loop
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
2:
             exx
             ld	        e,08h
             call	_checkkbd
             bit	0,l
             exx
             ret z                       ; exit if user press space
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; inner loop
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

1:          halt

            call   one_pixel

            ld     a,e
            inc    a
            and    7
            ld     e,a

            dec    a
            jr     nz,1b                 ; move the text of 8 pixels

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

            call   one_line

            inc    d

            ld     a,-24+(end_text-text)/32+1
            cp     d
            jr     nz,2b

            ret                          ; no more text to scroll

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

one_pixel:  xor    a
            out    (99h),a
            ld     a,64
            out    (99h),a

            ld     h,0
            ld     l,e

            ld     bc,ASCII
            add    hl,bc

            ld     bc,16*26*256+98h

1:          call   _out
            jp     nz,1b
1:          call   _out
            jp     nz,1b

            ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

one_line:   xor    a
            out    (99h),a
            ld     a,64+18h
            out    (99h),a

            ld      h,0
            ld      l,d

            rept    5
             add     hl,hl
            endm

            ld      bc,text
            add     hl,bc

            ld      bc,3*256*256+98h

1:          call   _out
            jp     nz,1b
1:          call   _out
            jp     nz,1b
1:          call   _out
            jp     nz,1b

            ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_out:       rept 32
            outi
            endm
            ret


text:
            rept 24
            rept 32
             db    255
            endm
            endm

            rept 6
             db    00,02,04,06,08,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,0xff,0xff,0xff,0xff,0xff,0xff
             db    01,03,05,07,09,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,0xff,0xff,0xff,0xff,0xff,0xff

             db    0xff,0xff,0xff,0xff,0xff,0xff,18,50,48,46,44,42,40,38,36,34,32,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50
             db    0xff,0xff,0xff,0xff,0xff,0xff,19,51,49,47,45,43,41,39,37,35,33,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51
            endm

            rept 24
            rept 32
             db    255
            endm
            endm
end_text:


ASCII:
;A
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x70,0x88,0x88,0xF8,0x88,0x88,0x00,0x00
;B
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0xE0,0x90,0xE0,0x90,0x88,0xF0,0x00,0x00
;C
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x70,0x88,0x80,0x80,0x88,0x70,0x00,0x00
;etc.
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0xF0,0x48,0x48,0x48,0x48,0xF0,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0xF8,0x80,0xE0,0x80,0x80,0xF8,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0xF8,0x80,0x80,0xE0,0x80,0x80,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x70,0x88,0x80,0xB8,0x88,0x70,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x88,0x88,0xF8,0x88,0x88,0x88,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x70,0x20,0x20,0x20,0x20,0x70,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x38,0x08,0x08,0x08,0x88,0x70,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x88,0x90,0xA0,0xE0,0x90,0x88,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x80,0x80,0x80,0x80,0x80,0xF8,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0xD8,0xA8,0xA8,0x88,0x88,0x88,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0xC8,0xA8,0xA8,0x98,0x98,0x88,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x70,0x88,0x88,0x88,0x88,0x70,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0xF0,0x88,0x88,0xF0,0x80,0x80,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x70,0x88,0x88,0xA8,0x90,0x68,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0xF0,0x88,0x88,0xF0,0xA0,0x98,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x70,0x80,0x70,0x08,0x08,0xF0,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0xF8,0x20,0x20,0x20,0x20,0x20,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x88,0x88,0x88,0x88,0x88,0x78,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x88,0x88,0x88,0x50,0x50,0x20,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x88,0x88,0xA8,0xA8,0xA8,0xD8,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x88,0x50,0x20,0x50,0x88,0x88,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0x88,0x88,0x70,0x20,0x20,0x20,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	db 0xF8,0x10,0x20,0x40,0x80,0xF8,0x00,0x00
	db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
